//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop
#include "SplashForm.h"
#include "Unit1.h"
//---------------------------------------------------------------------------
USEFORM("Unit1.cpp", Form1);
USERES("VisualAsm.res");
USEFORM("Unit2.cpp", Form2);
USEFORM("Unit3.cpp", Form3);
USEFORM("SplashForm.cpp", Splash);
USEFORM("NewItems.cpp", NewItemsForm);
USEFORM("ContribFrm.cpp", ContributorsFrm);
USEFORM("ConfigForms\CompilerConfig.cpp", CompilerConfigForm);
USEFORM("ConfigForms\ToolConfigAddDebuggerForm1.cpp", ToolConfigAddDebuggerForm);
USEFORM("ConfigForms\ToolConfigAddDisassemberForm1.cpp", ToolConfigAddDisassemblerForm);
USEFORM("ConfigForms\ToolConfigForm1.cpp", ToolConfigForm);
USEFORM("ConfigForms\VisasmConfig.cpp", VisAsmConfigForm);
USEFORM("ExtraForms\CmdLineForm.cpp", ExecutableCmdForm);
USEFORM("FileFind\FileFindForm1.cpp", FileFindForm);
USEUNIT("FileFind\FindInFile.cpp");
USEUNIT("FileFind\Lookdir.cpp");
USEFORM("ExtraForms\projman.cpp", ProjectMgr);
USEFILE("Unit1.h");
USEFORM("ExtraForms\add_data.cpp", AddDataForm);
USEFILE("ExtraForms\add_data.h");
USEFORM("FileFind\FileCompareForm1.cpp", FileCompareForm);
USEFILE("Unit2.h");
USEFILE("ExtraForms\projman.h");
USEFILE("SCR\scrf.hpp");
USELIB("SCR\scrf.lib");
USEUNIT("Editor Units\richEdUtils.pas");
USEFORM("ExtraForms\AsmWiz1.cpp", AsmWiz);
USEFILE("Unit3.h");
USEUNIT("Editor Units\SrcParser.pas");
USEUNIT("Editor Units\RichUnit.cpp");
USEUNIT("Editor Units\HighLightUtils.cpp");
USEFILE("Editor Units\HighLightUtils.h");
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
	try
	{
		Application->Initialize();

        // do the splashscreen thing
        Splash=new TSplash(Application);
        Splash->Position=poScreenCenter;
        Splash->Show();
        Splash->Repaint();
        Application->ProcessMessages();

        // create all the other forms
        Application->Title = "Visual Assembler";
        Application->CreateForm(__classid(TForm1), &Form1);
        Application->CreateForm(__classid(TForm2), &Form2);
        Application->CreateForm(__classid(TForm3), &Form3);
        Application->CreateForm(__classid(TFileFindForm), &FileFindForm);
        Application->CreateForm(__classid(TExecutableCmdForm), &ExecutableCmdForm);
        Application->CreateForm(__classid(TProjectMgr), &ProjectMgr);
        Application->CreateForm(__classid(TAddDataForm), &AddDataForm);
        Application->CreateForm(__classid(TFileCompareForm), &FileCompareForm);
        Application->CreateForm(__classid(TAsmWiz), &AsmWiz);
        switch ( Form1->InitiateStartSequence())
        { case 0 : break;  // no problems



          case 1 : Form1->RegisterNewUser();
          		   break;
            // no inifile ---> show application configuration menu

          case 2 :      Application->MessageBox("2",
                            "Application Exception", MB_OK|MB_ICONWARNING);
                        break;

            // no splitter ini, whatever, don't mind. use app defaults.

          case 3 :       Application->MessageBox("3",
                            "Application Exception", MB_OK|MB_ICONWARNING);
                         break;

            // no buttons ini: create the default

          case 4 :        Application->MessageBox("4",
                            "Application Exception", MB_OK|MB_ICONWARNING);
                          break;

            // problem creating tools menu. show tools menu setup dialog...

        }

        // now remove the splash thing
        Splash->Hide();
        delete Splash;

        // Ok , give control to Windows
   		Application->Run();
	}
	catch (Exception &exception)
	{
		Application->ShowException(&exception);
	}
	return 0; 
}
//---------------------------------------------------------------------------
